"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.useWebsocket = useWebsocket;
exports.useSendMessage = useSendMessage;
exports.useWebsocketPing = useWebsocketPing;
var _react = require("react");
var _appRouterContext = require("../../../../../shared/lib/app-router-context");
var _getSocketProtocol = require("./get-socket-protocol");
function useWebsocket(assetPrefix) {
    const webSocketRef = (0, _react).useRef();
    (0, _react).useEffect(()=>{
        if (webSocketRef.current) {
            return;
        }
        const { hostname , port  } = window.location;
        const protocol = (0, _getSocketProtocol).getSocketProtocol(assetPrefix);
        const normalizedAssetPrefix = assetPrefix.replace(/^\/+/, '');
        let url = `${protocol}://${hostname}:${port}${normalizedAssetPrefix ? `/${normalizedAssetPrefix}` : ''}`;
        if (normalizedAssetPrefix.startsWith('http')) {
            url = `${protocol}://${normalizedAssetPrefix.split('://')[1]}`;
        }
        webSocketRef.current = new window.WebSocket(`${url}/_next/webpack-hmr`);
    }, [
        assetPrefix
    ]);
    return webSocketRef;
}
function useSendMessage(webSocketRef) {
    const sendMessage = (0, _react).useCallback((data)=>{
        const socket = webSocketRef.current;
        if (!socket || socket.readyState !== socket.OPEN) {
            return;
        }
        return socket.send(data);
    }, [
        webSocketRef
    ]);
    return sendMessage;
}
function useWebsocketPing(websocketRef) {
    const sendMessage = useSendMessage(websocketRef);
    const { tree  } = (0, _react).useContext(_appRouterContext.GlobalLayoutRouterContext);
    (0, _react).useEffect(()=>{
        // Taken from on-demand-entries-client.js
        // TODO-APP: check 404 case
        const interval = setInterval(()=>{
            sendMessage(JSON.stringify({
                event: 'ping',
                // TODO-APP: fix case for dynamic parameters, this will be resolved wrong currently.
                tree,
                appDirRoute: true
            }));
        }, 2500);
        return ()=>clearInterval(interval);
    }, [
        tree,
        sendMessage
    ]);
}

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=use-websocket.js.map